import React, { useState } from 'react';
import Button from '@crm/components/dist/lego2/Button';
import { Provider } from 'services/PersonalCallService';
import { PersonalCallServiceStub } from 'services/PersonalCallService';
import { CallPopup } from './CallPopup';
import { TestBed } from '../../TestBed';

export default {
  title: 'CallPopup/CallPopup',
  component: CallPopup,
  argTypes: {
    onMinimize: { action: 'minimize' },
  },
};

const personalCallServiceStub = new PersonalCallServiceStub();

const TestComponent: React.FC<{ isCallActive: boolean; onMinimize: () => void }> = ({
  isCallActive,
  onMinimize,
}) => {
  const [isVisible, setIsVisible] = useState(false);

  return (
    <TestBed>
      <Provider value={personalCallServiceStub}>
        <Button onClick={() => setIsVisible(!isVisible)}>Toggle popup</Button>
        <CallPopup
          isLoading={false}
          isCallActive={isCallActive}
          isVisible={isVisible}
          onMinimize={onMinimize}
        />
      </Provider>
    </TestBed>
  );
};

export const Default = (args) => <TestComponent {...args} />;

Default.args = {
  isCallActive: false,
};
