import differenceWith from 'lodash/differenceWith';
import { Opportunity } from 'components/Attribute2/types/Opportunity';
import { IssueEntity } from 'types';

export const getNewOpportunities = (changedIssues: Opportunity[], issues: IssueEntity[]) => {
  return differenceWith(
    changedIssues,
    issues,
    ({ id: newId }, { id: oldId }) => newId.toString() === oldId.toString(),
  );
};

export const getDeletedOpportunities = (changedIssues: Opportunity[], issues: IssueEntity[]) => {
  return differenceWith(
    issues,
    changedIssues,
    ({ id: newId }, { id: oldId }) => newId.toString() === oldId.toString(),
  );
};
