import React from 'react';
import { CallPopupIcon } from './CallPopupIcon';

export default {
  title: 'CallPopup/CallPopupIcon',
  component: CallPopupIcon,
  decorators: [
    (Story) => (
      <div style={{ backgroundColor: '#262633' }}>
        <Story />
      </div>
    ),
  ],
};

export const ActiveCall = (args) => <CallPopupIcon {...args} />;
export const FinishedCall = (args) => <CallPopupIcon {...args} />;

ActiveCall.args = {
  isCallActive: true,
};

FinishedCall.args = {
  isCallActive: false,
};
