import React, { Ref } from 'react';
import cx from 'classnames';
import Icon from '@crm/components/dist/lego2/Icon';
import css from './CallPopupIcon.module.css';

interface CallPopupIconProps {
  isCallActive: boolean;
  onClick: () => void;
}

export const CallPopupIcon = React.forwardRef(((
  { isCallActive, onClick },
  ref: Ref<HTMLDivElement>,
) => {
  return (
    <div
      data-testid="call-popup-icon"
      ref={ref}
      className={cx(css.CallPopupIcon, { [css.CallPopupIcon_isCallActive]: isCallActive })}
      onClick={onClick}
    >
      <Icon className={css.CallPopupIcon} svg="phone2" svgSize="l" />
    </div>
  );
}) as React.FC<CallPopupIconProps>);
