import React, { FC } from 'react';
import { Text } from '@crm/components/dist/lego2/Text';
import Icon from '@crm/components/dist/lego2/Icon';
import { PersonalCallData } from 'types/PersonalCallData';
import css from './CallToast.module.css';

interface CallToastProps {
  callData?: PersonalCallData;
}

export const CallToast: FC<CallToastProps> = ({ callData }) => {
  const { phoneNumber, account } = callData ?? {};

  return (
    <div data-testid="call-toast" className={css.CallToast}>
      <Icon className={css.CallToast__icon} svg="phone2" svgSize="l" />
      <div className={css.CallToast__callData}>
        <Text typography="body-short-l" color="inverse" weight="medium">
          {phoneNumber}
        </Text>
        {account?.info?.name && (
          <Text typography="body-short-m" color="ghost" weight="medium">
            {account.info.name}
          </Text>
        )}
      </div>
    </div>
  );
};

export default CallToast;
