import * as React from 'react';
import ToolTip from 'lego/components/ToolTip';
import Icon from 'lego/components/Icon';
import ChangesRequest from './ChangesRequest';
import css from './PopupChangesRequest.scss';

const preview = ({ value }) => value;

const PopupChangesRequest = props => {
  const { items } = props;

  if (!(Array.isArray(items) && items.length)) {
    return null;
  }

  return (
    <ToolTip
      tooltip={<ChangesRequest previewComponent={preview} {...props} />}
      hideDelay={100}
      autoZIndex
    >
      <Icon pack={Icon.PACKS.MATERIAL} icon="warning" className={css.b__icon} />
    </ToolTip>
  );
};

export default PopupChangesRequest;
