import React, { useState } from 'react';
import { StatefulColorInput } from './StatefulColorInput';
import { DEFAULT_COLOR_COLLECTION } from './ColorInput.constants';

export const ColorInput = (props) => {
  const [currentColor, setCurrentColor] = useState<string>(props.value);
  const changeColor = (clr) => {
    setCurrentColor(clr);
  };
  return (
    <div style={{ width: props.containerSize }}>
      <div
        style={{
          display: 'grid',
          alignItems: 'center',
          justifyContent: 'center',
          marginBottom: '16px',
          borderRadius: '8px',
          height: '50px',
          width: '100%',
          backgroundColor: currentColor,
        }}
      >
        <h2 style={{ margin: 0 }}>{currentColor}</h2>
      </div>
      <StatefulColorInput {...props} onChange={changeColor} defaultValue={currentColor} />
    </div>
  );
};

export default {
  title: 'ColorInput',
  component: ColorInput,
  args: {
    colorCollection: DEFAULT_COLOR_COLLECTION,
    containerSize: '250px',
    value: DEFAULT_COLOR_COLLECTION[0],
    xScrollable: false,
  },
};
