import React, { FC } from 'react';
import cx from 'classnames';
import css from './ColorInput.module.css';
import { ColorInputProps } from './ColorInput.types';
import { DEFAULT_COLOR_COLLECTION } from './ColorInput.constants';
import { ColorInputItem } from './ColorInputItem';
export const ColorInput: FC<ColorInputProps> = (props) => {
  const {
    className,
    onChange,
    value = '#FF9E94',
    size = 'm',
    colorCollection = DEFAULT_COLOR_COLLECTION,
    xScrollable = false,
  } = props;

  const classNames = cx(
    css.ColorInput,
    css[`ColorInput_size_${size}`],
    { [css.ColorInput_xScrollable]: xScrollable },
    className,
  );

  const colors = Array.isArray(colorCollection) ? colorCollection : DEFAULT_COLOR_COLLECTION;

  return (
    <div className={classNames} data-testid="ColorInput">
      {colors.map((color) => (
        <ColorInputItem
          key={color}
          color={color}
          isChecked={color === value}
          onChange={onChange}
          size={size}
        />
      ))}
    </div>
  );
};
