import React, { FC } from 'react';
import cx from 'classnames';
import Icon from '@crm/components/dist/lego2/Icon';
import css from './ColorInputItem.module.css';
import { ColorInputItemProps } from './ColorInputItem.types';

export const ColorInputItem: FC<ColorInputItemProps> = ({
  isChecked = false,
  onChange,
  color = '#FF9E94',
  size = 'm',
}) => {
  const handleClick = () => {
    onChange?.(color);
  };
  const className = cx(css.ColorInputItem, css[`ColorInputItem_size_${size}`]);
  return (
    <div onClick={handleClick} className={className} style={{ backgroundColor: color }}>
      {isChecked && <Icon svg="check" />}
    </div>
  );
};
