import React, { useState, FC } from 'react';
import { StatefulColorInputProps } from './StatefulColorInput.types';
import { ColorInput } from '../ColorInput';

export const StatefulColorInput: FC<StatefulColorInputProps> = (props) => {
  const { defaultValue, onChange } = props;
  const [currentColor, setCurrentColor] = useState<string | undefined>(defaultValue);

  const handleChange = (color: string) => {
    setCurrentColor(color);
    onChange?.(color);
  };

  return <ColorInput {...props} onChange={handleChange} value={currentColor} />;
};
