import React from 'react';
import PlainText from 'components/PlainText';
import FilesList from 'components/FilesList';

export interface CommentType {
  text: string;
  isHtml: boolean;
  files: unknown;
}

interface Props {
  className: string;
  comment: CommentType;
}

const Comment = (props: Props) => {
  const { className, comment } = props;

  if (!comment) {
    return null;
  }

  return (
    <div className={className}>
      <PlainText text={comment.text} isHtml={comment.isHtml} link />
      <FilesList files={comment.files} isInline />
    </div>
  );
};

Comment.defaultProps = {
  className: '',
};

export default Comment;
