import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import css from './styles.modules.scss';

export default class CompleteOverlay extends React.Component {
  static propTypes = {
    isComplete: PropTypes.bool, // is complete interactive with form and e.g.
    message: PropTypes.node,
    children: PropTypes.node,
    className: PropTypes.string,
  };

  static defaultProps = {
    isComplete: false,
    message: undefined,
    children: undefined,
    className: undefined,
  };

  renderSuccess = () => {
    if (this.props.isComplete) {
      return (
        <div className={css.successWrap}>
          <div className={css.success}>
            <i className="material-icons">done</i>
          </div>
          {this.props.message ? <div>{this.props.message}</div> : null}
        </div>
      );
    }
    return false;
  };

  render() {
    return (
      <div className={cx(css.wrap, this.props.className)}>
        {this.props.children}
        {this.renderSuccess()}
      </div>
    );
  }
}
