import React from 'react';
import { FormByScheme } from 'components/FormByScheme';
import { ConfirmFormProps } from './ConfirmForm.types';

const formScheme = {
  data: [],
  meta: {
    fields: [],
    fieldsVisibility: [],
  },
};

export const ConfirmForm: React.FC<ConfirmFormProps> = ({
  onSubmitSuccess,
  onCancel,
  title,
  description,
}) => {
  return (
    <FormByScheme
      title={title}
      description={description}
      onSubmit={onSubmitSuccess}
      onCancel={onCancel}
      scheme={formScheme}
      successButtonText="Да"
      cancelButtonText="Нет"
    />
  );
};
