import React from 'react';
import Button from '@crm/components/dist/lego2/Button';
import { ModalContainer } from 'lego/utils/modalForm';
import { ConfirmModalForm } from './ConfirmModalForm';

export default {
  title: 'ConfirmForm/ConfirmModalForm',
  component: ConfirmModalForm,
  argTypes: {
    onSubmitSuccess: { action: 'submitted' },
    onClose: { action: 'closed' },
  },
};

export const Default = (args) => (
  <>
    <Button
      onClick={() =>
        ConfirmModalForm.open({
          title: 'Требуется подтверждение',
          description: 'Точно-точно?',
          onSubmitSuccess: args.onSubmitSuccess,
          onClose: args.onClose,
        })
      }
    >
      open modal
    </Button>
    <ModalContainer />
  </>
);
