import React from 'react';
import { FormattedDate } from 'react-intl';
import { CommentData } from 'types';
import cx from 'classnames';
import PlainText from 'components/PlainText';
import StaffCard from 'components/StaffCard';
import css from './Comment.module.css';

interface Props {
  data: CommentData;
  className: string;
}

const Comment = (props: Props): React.ReactElement => {
  const {
    data: { text, author, date },
    className,
  } = props;

  return (
    <div className={cx(css.comment, className)}>
      <div className={css.comment__header}>
        <span className={css.comment__label}>Комментарий</span>
        <span className={css.comment__meta}>
          <StaffCard user={author} />
          &nbsp;
          <FormattedDate
            value={new Date(date)}
            year="numeric"
            month="numeric"
            day="numeric"
            hour="numeric"
            minute="numeric"
          />
        </span>
      </div>
      <PlainText text={text} link />
    </div>
  );
};

Comment.defaultProps = {
  className: undefined,
};

export default Comment;
