/*
eslint-disable
jsx-a11y/anchor-is-valid,
jsx-a11y/no-noninteractive-tabindex,
jsx-a11y/click-events-have-key-events,
jsx-a11y/no-static-element-interactions,
jsx-a11y/mouse-events-have-key-events,
*/

import React from 'react';
import WordBreak from 'components/WordBreak';
import { ContactMassmailData, Email } from 'types';
import convertContactMassmailData2ContactData from 'types/convertContactMassmailData2ContactData';
import Icon from 'lego/components/Icon';
import cx from 'classnames';
import createI18N from '@yandex-int/i18n';
import * as keyset from './Contact.i18n';
import css from './ContactCompact.module.css';
import Comment from './Comment';

const i18nForBroadcast = createI18N(keyset)('forBroadcast');

interface RenderMailData {
  email: Email;
  contactId: number;
  accountId: number;
}

const renderEmail = (data: RenderMailData) => {
  const { email } = data;

  return (
    <div key={email.email} className={css.emailItem}>
      {email.isBroadcast && (
        <i title={i18nForBroadcast} className="material-icons">
          mail
        </i>
      )}
      {email.email || '–'}
    </div>
  );
};

interface Props {
  className?: string;
  contact: ContactMassmailData;
  id: number;
  onEdit: () => void;
  onDelete: () => void;
  accountId: number;
  canEdit?: boolean;
  children?: React.ReactNode;
}

const Contact = (props: Props): null | React.ReactElement => {
  const { className, id, contact, accountId } = props;

  if (!contact) {
    return null;
  }

  const formattedContact = convertContactMassmailData2ContactData(contact);

  const {
    isMain,
    comment,
    firstName,
    lastName,
    middleName,
    position,
    emails,
    language,
  } = formattedContact;

  let lang: string | null = null;
  if (language) {
    lang = language.code;
  }

  let job: string | null = null;
  if (position) {
    job = position.name;
  }

  return (
    <WordBreak className={cx(className, css.contact)}>
      <div className={css.row}>
        <div className={css.name}>
          {isMain && (
            <Icon pack={Icon.PACKS.MATERIAL} icon="star" className={css.contact__mainIcon} />
          )}
          {!lastName && !firstName && !middleName && '–'}
          {lastName} {firstName} {middleName} {lang ? `(${lang})` : null}
          {job && <div className={css.position}>{job}</div>}
        </div>
        <div className={css.email}>
          {emails &&
            emails.length > 0 &&
            emails.map(email =>
              renderEmail({
                email,
                contactId: id,
                accountId,
              }),
            )}
          {(!emails || !emails.length) && '–'}
        </div>
      </div>
      {comment && <Comment data={comment} className={css.comment} />}
    </WordBreak>
  );
};

Contact.defaultProps = {
  className: undefined,
  comment: undefined,
  accountId: undefined,
  canEdit: undefined,
  onEdit: undefined,
  onDelete: undefined,
  children: undefined,
};

export default Contact;
