import React, { FC } from 'react';
import createI18N from '@yandex-int/i18n';
import { CallTo } from 'modules/phone';
import css from '../ContactFull.module.css';
import * as keyset from '../Contact.i18n';
import { PhoneProps } from './Phone.types';

const i18n = createI18N(keyset);
const i18nCall = i18n('call');
const i18nExtPhone = i18n('extPhone');

export const Phone: FC<PhoneProps> = (props) => {
  const { phone: phoneData, callToComponent: CallToComponent = CallTo } = props;
  const { id, phone, phoneExt, phoneE164 } = phoneData;

  return (
    <div key={id} className={css.phoneItem}>
      {phoneExt
        ? [
            phone,
            ' ',
            <span key="phoneExt" title={i18nExtPhone}>
              ({phoneExt})
            </span>,
          ]
        : phone}
      {phoneE164 && (
        <div className={css.action}>
          <CallToComponent phone={phoneE164} phoneData={phoneData} cardData={{ accountKikId: id }}>
            {i18nCall}
          </CallToComponent>
        </div>
      )}
    </div>
  );
};
