import pick from 'lodash/pick';
import { ContactData } from 'types';

const FORM_ATTRS = [
  'contactId',
  'firstName',
  'lastName',
  'middleName',
  'phones',
  'emails',
  'sync',
  'birthDate',
  'comment.text',
  'isMain',
  'position',
  'language',
];

export const getInitialValues = (contact: ContactData, keys: string[] = FORM_ATTRS) => {
  const initialValues = pick(contact, keys) as Partial<ContactData> & {
    positionId: number;
    languageId: number;
  };

  if (initialValues.position) {
    initialValues.positionId = initialValues.position.id;
    delete initialValues.position;
  }

  if (initialValues.language) {
    initialValues.languageId = initialValues.language.id;
    delete initialValues.language;
  }

  return initialValues;
};
