import React, { FC } from 'react';
import cx from 'classnames';
import ReactDatePicker, { registerLocale } from '@crm/react-datepicker';
import ru from 'date-fns/locale/ru';
import '@crm/react-datepicker/dist/react-datepicker.css';
import './DatePicker.css';
import { DatePickerProps } from './DatePicker.types';

registerLocale('ru', ru);
export const DatePicker: FC<DatePickerProps> = (props) => {
  const {
    locale = 'ru',
    inline = true,
    highlightWeekend = false,
    showPopperArrow = false,
    dateFormat = 'dd.MM.yyyy',
    onVisibleRange,
    view = 'default',
    onChange = () => {},
    ...restProps
  } = props;

  const calendarClassname = cx(
    props.calendarClassName,
    'react-datepicker--common',
    `react-datepicker_view_${view}`,
    {
      'react-datepicker--highlightWeekend': highlightWeekend,
    },
  );

  return (
    <ReactDatePicker
      locale={locale}
      inline={inline}
      onChange={onChange}
      {...restProps}
      onVisibleRange={onVisibleRange}
      dateFormat={dateFormat}
      showPopperArrow={showPopperArrow}
      showMonthDropdown
      showYearDropdown
      calendarClassName={calendarClassname}
    />
  );
};
