import React, { useState } from 'react';
import { DatePicker as DatePickerComponent } from '../DatePicker';

export default {
  title: 'DatePicker',
  component: DatePickerComponent,
};

const DatePicker = ({ inline, highlightWeekend }) => {
  const [date, setDate] = useState<Date | null>(new Date());
  return (
    <DatePickerComponent
      selected={date}
      onChange={setDate}
      inline={inline}
      highlightWeekend={highlightWeekend}
    />
  );
};

DatePicker.args = {
  inline: false,
  highlightWeekend: false,
};

export { DatePicker };
