import React from 'react';
import { FormattedDate, FormattedTime } from 'react-intl';


const DateTime = ({ value, className }) => {
    // Force Moscow timezone
    value = value.replace(/\+.+$/, '') + '+03:00';

    return (
        <span className={className}>
            <FormattedDate value={ value } />&nbsp;
            <FormattedTime value={ value } hour="numeric" minute="numeric" />
        </span>
    );
};

export default DateTime;
