import React from 'react';
import { get } from 'api/common';
import { PopupFilteredMenuInfinite } from 'lego/components/FilteredMenu';
import LinkButton from './LinkButton';

class DictInput extends React.Component {
  static Types = {
    BusinessUnit: 'businessUnit',
    Service: 'service',
  };

  static Urls = {
    businessUnit: '/view/dicts/businessUnit',
    service: '/view/dicts/service',
  };

  provider = (args = {}) => {
    const { ticketId, requestId, accountId, inn, contractId, type } = this.props;

    return get({
      url: DictInput.Urls[type],
      data: {
        ticketId,
        requestId,
        accountId,
        inn,
        contractId,
        ...args,
      },
    });
  };

  render() {
    return (
      <PopupFilteredMenuInfinite
        name={this.props.type}
        delay={300}
        provider={this.provider}
        onChange={this.props.onChange}
        toggleNode={<LinkButton>изменить</LinkButton>}
        autoFocus
      />
    );
  }
}

export default DictInput;
