import React, { FC } from 'react';
import cx from 'classnames';
import { Divider as LegoDivider } from '@yandex-lego/components/Divider';
import { DividerProps } from './Divider.types';
import css from './Divider.module.css';

export const Divider: FC<DividerProps> = (props) => {
  const { margin = 16, color = 'var(--color-mg-control-disabled-stroke)', ...restProps } = props;
  const style = {
    marginLeft: margin ? `${margin}px` : 0,
    marginRight: margin ? `${margin}px` : 0,
    width: margin ? `calc(100% - ${margin * 2}px)` : '100%',
  };
  const className = cx(css.Divider, props.className);

  return <LegoDivider {...restProps} color={color} className={className} style={style} />;
};
