import React, { useMemo } from 'react';
import { useDropzone } from 'react-dropzone';
import cx from 'classnames';
import { DropTarget } from 'react-dnd';
import { DNDType } from 'components/FilesList';
import { DropzoneProps } from './Dropzone.types';
import css from './Dropzone.module.css';
import { onlyChild } from './Dropzone.utils';
import { StrokeContainer } from './StrokeContainer';

const AttachTarget = {
  canDrop: (props: DropzoneProps) => !props.disabled,
  drop: (props: DropzoneProps, monitor) => {
    const fileId = monitor.getItem().id;
    props.onDrop?.([fileId], [], new Event('dropFileId'));
  },
};

const collect = (connect, monitor) => ({
  connectDropTarget: connect.dropTarget(),
  isFileOver: monitor.isOver(),
});

export const DropzoneBase: React.FC<DropzoneProps & ReturnType<typeof collect>> = (props) => {
  const { onDrop, accept, children, isFileOver, disabled } = props;
  const { getRootProps, getInputProps, isDragActive } = useDropzone({ onDrop, accept, disabled });

  const isActive = useMemo(() => !disabled && (isDragActive || isFileOver), [
    isDragActive,
    isFileOver,
  ]);

  const className = cx(css.Dropzone, props.className, {
    [css.Dropzone_active]: isActive,
  });

  const strokeClassName = cx(css.Dropzone__stroke, {
    [css.Dropzone__stroke_active]: isActive,
  });

  return props.connectDropTarget(
    <div {...getRootProps({ className })}>
      <StrokeContainer
        className={css.Dropzone__strokeContainer}
        strokeClassName={strokeClassName}
        radius={24}
        width={3}
      >
        <input {...getInputProps()} />
        {typeof onlyChild(children) === 'function' ? onlyChild(children)(isActive) : children}
      </StrokeContainer>
    </div>,
  );
};

export const Dropzone = DropTarget(DNDType, AttachTarget, collect)(DropzoneBase);
