import React from 'react';
import { useMemo } from 'react';
import { StrokeContainerProps } from './StrokeContainer.types';
import css from './StrokeContainer.module.css';

export const StrokeContainer: React.FC<StrokeContainerProps> = ({
  className,
  strokeClassName,
  children,
  color = 'black',
  width = 1,
  dashes = [12, 12],
  offset = 0,
  linecap = 'round',
  radius = 0,
}) => {
  const dasharray = useMemo(() => dashes.join(' '), [dashes]);
  const strokePadding = useMemo(() => width / 2, [width]);

  return (
    <div className={className} style={{ position: 'relative' }}>
      <svg
        className={css.StrokeContainer__svg}
        style={{ padding: strokePadding }}
        xmlns="http://www.w3.org/2000/svg"
      >
        <rect
          width="100%"
          height="100%"
          fill="none"
          rx={radius}
          ry={radius}
          stroke={color}
          strokeWidth={width}
          strokeDasharray={dasharray}
          strokeDashoffset={offset}
          strokeLinecap={linecap}
          className={strokeClassName}
        />
      </svg>
      {children}
    </div>
  );
};
