import React from 'react';
import PropTypes from 'prop-types';

const INTERVALS = [{ mod: 60 * 1000, name: 'мин' }, { mod: 1000, name: 'сек' }];

const durationFormatter = (duration = 0) => {
  let $duration = Math.floor(duration);

  return INTERVALS.reduce((str, interval) => {
    if ($duration) {
      const { mod, name } = interval;

      let value;
      if (mod) {
        value = Math.floor($duration / mod);
        $duration %= mod;
      } else {
        value = $duration;
        $duration = 0;
      }

      if (value) {
        return `${str} ${value}${name}`;
      }
    }

    return str;
  }, '');
};

const Duration = (props) => {
  const { duration, ...passPropsThrough } = props;

  return (
    <span {...passPropsThrough}>
      {durationFormatter(duration)}
    </span>
  );
};

Duration.propTypes = {
  duration: PropTypes.number.isRequired,
};

export default Duration;
