import React, { FC } from 'react';
import { observer } from 'mobx-react-lite';
import Modal from '@crm/components/dist/lego2/Modal';
import { Overlay } from 'components/Overlay';
import { FormByScheme } from 'components/FormByScheme/FormByScheme';
import css from './DynamicallyModalForm.module.css';
import { useDynamicallyModalForm } from './DynamicallyModalForm.context';

export const DynamicallyModalForm: FC = observer(() => {
  const dynamicallyForm = useDynamicallyModalForm();
  const {
    isLoading,
    formData,
    submitForm,
    onChange,
    initialValues,
    isUpdatingFields,
  } = dynamicallyForm;
  return (
    <Modal
      visible={Boolean(formData || isLoading)}
      theme="normal"
      onClose={dynamicallyForm.handleCloseForm}
      hasAnimation={false}
      title={formData?.meta?.title}
      limitHeight
    >
      <Overlay
        className={css.DynamicallyModalForm__overlay}
        display={isLoading}
        hasSpinner
        zIndex={11}
        color="rgba(255,255,255,.9)"
      />
      {formData && (
        <div className={css.DynamicallyModalForm}>
          <FormByScheme
            scheme={formData}
            onSubmit={submitForm}
            onChange={onChange}
            onCancel={dynamicallyForm.handleCloseForm}
            initialValues={initialValues}
            buttonsDisabled={isUpdatingFields}
          />
        </div>
      )}
    </Modal>
  );
});
