import React from 'react';
import Icon from '@crm/components/dist/lego2/Icon';
import Button from '@crm/components/dist/lego2/Button';
import { EditInfoPanelProps } from './EditInfoPanel.types';
import css from './EditInfoPanel.module.css';

export const EditInfoPanel: React.FC<EditInfoPanelProps> = (props) => {
  const { text, onClearClick } = props;

  return (
    <div className={css.b}>
      <div className={css.b__container}>
        <div className={css.b__title}>Редактировать</div>
        <div className={css.b__text}>{text}</div>
      </div>
      <Button icon={() => <Icon svg="clear" />} onClick={onClearClick} view="clear" />
    </div>
  );
};
