import React from 'react';
import PropTypes from 'prop-types';
import { getCKEDITOR } from 'components/RichHtmlEditor';

class EditorMacros extends React.Component {
  static propTypes = {
    editorId: PropTypes.string.isRequired,
    macroId: PropTypes.string.isRequired, // eslint-disable-line react/no-unused-prop-types
    value: PropTypes.any, // eslint-disable-line react/forbid-prop-types
  };

  static defaultProps = {
    value: undefined,
  };

  constructor(props) {
    super(props);

    const { editorId } = props;

    getCKEDITOR().then((CKEDITOR) => {
      const editor = CKEDITOR.instances[editorId];
      if (editor) {
        this.editor = editor;
      } else {
        CKEDITOR.once('instanceReady', (e) => {
          if (e.editor.name === this.props.editorId) {
            this.editor = e.editor;
            this.replace(this.props);
          }
        });
      }
    });

    this.isReplace = false;
  }

  componentWillReceiveProps(nextProps) {
    if (nextProps.value !== this.props.value) {
      this.replace(nextProps);
    }
  }

  replace(props) {
    if (this.editor && this.editor.mode !== 'source') {
      let html = this.editor.getData() || '';
      if (html) {
        let isHtmlChange = false;
        const { macroId } = props;
        const value = props.value || '\u200B';
        if (!this.isReplace) {
          const reg = new RegExp(`{{${macroId}}}`);
          if (reg.test(html)) {
            html = html.replace(
              new RegExp(`{{${macroId}}}`),
              `<span data-crm-macros="${macroId}">${value}</span>`,
            );
            isHtmlChange = true;
            this.isReplace = true;
          }
        } else {
          const div = document.createElement('div');
          div.innerHTML = html;
          const macroElement = div.querySelector(`[data-crm-macros="${macroId}"]`);
          if (macroElement) {
            macroElement.innerHTML = value;
            html = div.innerHTML;
            isHtmlChange = true;
          }
        }

        if (isHtmlChange) {
          this.editor.setData(html);
        }
      }
    }
  }

  render() {
    return null;
  }
}

export default EditorMacros;
