/* eslint-disable react/no-find-dom-node */
import React, { createElement } from 'react';
import PropTypes from 'prop-types';
import ReactDOM from 'react-dom';
import css from './styles.modules.scss';

export default class Menu extends React.Component {
  componentDidUpdate() {
    const selectedNode = ReactDOM.findDOMNode(this.selectedNode);
    if (selectedNode) {
      const cO = selectedNode.offsetTop;
      const cH = selectedNode.offsetHeight;
      const pH = this.menu.clientHeight;
      const pS = this.menu.scrollTop;
      if (cO + cH > pH + pS) {
        this.menu.scrollTop = (cO - pH) + cH;
      } else if (cO < pS) {
        this.menu.scrollTop = cO;
      }
    }
  }

  /* public api */
  next() {
    const nextIndex = this.props.hoverIndex + 1;
    if (nextIndex < this.props.items.length) {
      this.props.onHoverIndexChange(nextIndex);
    }
  }

  previous() {
    const previousIndex = this.props.hoverIndex - 1;
    if (previousIndex >= 0) {
      this.props.onHoverIndexChange(previousIndex);
    }
  }
  /* end public api */

  handleMouseDown = (e) => {
    e.preventDefault();
    e.stopPropagation();
  };

  selectedNodeRef = (node) => { this.selectedNode = node; };

  renderChild = (item, index) => {
    const isHover = index === this.props.hoverIndex;
    const commonProps = {
      key: index,
      index,
      onHoverIndexChange: this.props.onHoverIndexChange,
      hover: isHover,
      ref: isHover ? this.selectedNodeRef : null,
      ...this.props.itemProps,
    };

    let element;
    if (typeof item === 'object') {
      element = createElement(this.props.itemComponent, { ...commonProps, ...item });
    } else {
      element = createElement(this.props.itemComponent, commonProps, item);
    }

    return element;
  };

  render() {
    const {
      className,
      items,
    } = this.props;

    return (
      <div
        className={className}
        onMouseDown={this.handleMouseDown}
        ref={(node) => { this.menu = node; }}
      >
        { items.map(this.renderChild) }
      </div>
    );
  }
}

Menu.propTypes = {
  items: PropTypes.arrayOf(PropTypes.any),
  hoverIndex: PropTypes.number.isRequired,
  onHoverIndexChange: PropTypes.func.isRequired,
  className: PropTypes.string,
  itemComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.string]),
  itemProps: PropTypes.objectOf(PropTypes.any),
};

Menu.defaultProps = {
  className: undefined,
  items: [],
  itemComponent: 'div',
  itemProps: {},
};
