import React, { createElement } from 'react';
import PropTypes from 'prop-types';
import MenuItemComponent from './MenuItemComponent';

export default class MenuItem extends React.Component {
  handleMouseOver = () => {
    this.props.onHoverIndexChange(this.props.index);
  };

  handleClick = () => {
    this.props.onClick(this.props.email);
  };

  render() {
    const passThroughProps = {
      ...this.props,
      onClick: this.handleClick,
      onMouseOver: this.handleMouseOver,
    };

    return createElement(MenuItemComponent, passThroughProps);
  }
}

MenuItem.propTypes = {
  onClick: PropTypes.func.isRequired,
  email: PropTypes.string.isRequired,
  onHoverIndexChange: PropTypes.func.isRequired,
  index: PropTypes.number.isRequired,
};
