import React from 'react';
import PropTypes from 'prop-types';
import css from './styles.modules.scss';
import TRANSLATE from './constants';

const MenuItemComponent = (props) => {
  const {
    email,
    hover,
    type,
    position,
    name,
    ...passThroughProps
  } = props;

  const className = hover ? css.suggestItem_selected : css.suggestItem;

  const subTextArray = [];

  if (TRANSLATE[type]) {
    subTextArray.push(TRANSLATE[type]);
  }
  if (name) {
    subTextArray.push(name);
  }
  if (position) {
    subTextArray.push(position);
  }

  const subText = subTextArray.join(' - ');

  return (
    <div className={className} {...passThroughProps}>
      <div className={css.suggestItem__text_sub}>{subText}</div>
      <div className={css.suggestItem__text}>{email}</div>
    </div>
  );
};

MenuItemComponent.propTypes = {
  email: PropTypes.node.isRequired,
  type: PropTypes.string,
  subText: PropTypes.node,
  hover: PropTypes.bool,
  name: PropTypes.string,
  position: PropTypes.string,
};

MenuItemComponent.defaultProps = {
  type: undefined,
  subText: undefined,
  hover: false,
  name: undefined,
  position: undefined,
};

export default MenuItemComponent;
