import React from 'react';
import PropTypes from 'prop-types';
import EmailInput from 'components/EmailInput';

export default class EmailInputUI extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      value: props.defaultValue,
      focused: false,
    };
  }

  onFocus = () => {
    this.setState({ focused: true });
  };

  onBlur = () => {
    this.setState({ focused: false });
  };

  handleChange = value => {
    this.setState({ value });
  };

  value() {
    return this.state.value;
  }

  render() {
    return (
      <EmailInput
        {...this.props}
        {...this.state}
        size="m"
        onChange={this.handleChange}
        onFocus={this.onFocus}
        onBlur={this.onBlur}
      />
    );
  }
}

EmailInputUI.propTypes = {
  defaultValue: PropTypes.string,
};

EmailInputUI.defaultProps = {
  defaultValue: '',
};
