import React from 'react';
import PropTypes from 'prop-types';
import createI18N from '@yandex-int/i18n';
import cx from 'classnames';
import { EmptyBlock } from 'components/EmptyBlock';
import * as keyset from './Empty.i18n';
import css from './Empty.modules.scss';

const i18n = createI18N(keyset);
const i18nEmptySearch = i18n('emptySearch');
const i18nEmptyData = i18n('emptyData');

const THEMES = {
  EMPTY_SEARCH: {
    text: i18nEmptySearch,
    icon: 'search',
  },
  EMPTY_DATA: {
    text: i18nEmptyData,
    icon: 'storage',
  },
};

/** @deprecated use src/components/EmptyBlock */
const Empty = ({ className, text, icon, theme, mode }) => {
  const themeObj = theme || { text, icon };

  return (
    <EmptyBlock
      className={cx(className, css.empty, css[`empty_mode_${mode}`])}
      iconProvider={() => (
        <div className={css.empty__icon}>
          <i className="material-icons">{themeObj.icon}</i>
        </div>
      )}
      title={themeObj.text}
      size="m"
    />
  );
};

Empty.THEMES = THEMES;

Empty.propTypes = {
  className: PropTypes.string,
  text: PropTypes.string,
  icon: PropTypes.string,
  mode: PropTypes.string,
  theme: PropTypes.instanceOf(Object),
};

Empty.defaultProps = {
  className: undefined,
  text: i18nEmptyData,
  icon: 'search',
  theme: undefined,
  mode: 'overflow',
};

export default Empty;
