import { SvgSize } from '@crm/components/dist/lego2/Icon';
import { TextProps } from '@crm/components/dist/lego2/Text';
import { EmptyBlockSize, EmptyBlockView } from './EmptyBlock.types';

export const mapSizeToTitleTypography: Record<EmptyBlockSize, TextProps['typography']> = {
  s: 'body-long-m',
  m: 'body-short-l',
};

export const mapViewToTextColor: Record<EmptyBlockView, TextProps['color']> = {
  dark: 'primary',
  light: 'secondary',
};

export const mapSizeToSvgSize: Record<EmptyBlockSize, SvgSize> = {
  s: 'xxl',
  m: 'xxxl',
};
