import React from 'react';
import Button from '@crm/components/dist/lego2/Button';
import { EmptyBlock } from './EmptyBlock';

export default {
  title: 'EmptyBlock',
  component: EmptyBlock,
};

export const emptyBlock = (args) => <EmptyBlock {...args} />;
emptyBlock.args = {
  title: 'Title',
  description: 'Description',
  view: 'dark',
  icon: 'inbox',
  size: 's',
};

export const showcase = (args) => {
  const style = {
    display: 'grid',
    gridTemplateColumns: 'repeat(4, 1fr)',
    gap: '10px',
    alignItems: 'center',
  };

  return (
    <div style={style}>
      <EmptyBlock {...args} title="Список пуст" />
      <EmptyBlock {...args} icon="chat2" title="Здесь будут ваши коммуникации" />
      <EmptyBlock {...args} icon="alert" title="Что-то пошло не так">
        <Button>Обновить</Button>
      </EmptyBlock>
      <EmptyBlock
        {...args}
        icon="lock2"
        title="У вас нет доступа"
        description="Напишите на help@crm.yandex-team.ru, 
чтобы получить доступ к странице"
      >
        <Button>Написать в поддержку</Button>
      </EmptyBlock>
    </div>
  );
};
showcase.args = {
  size: 's',
  view: 'dark',
};
