import React, { FC } from 'react';
import cx from 'classnames';
import Icon from '@crm/components/dist/lego2/Icon';
import { Text } from '@crm/components/dist/lego2/Text';
import { EmptyBlockProps } from './EmptyBlock.types';
import {
  mapSizeToSvgSize,
  mapViewToTextColor,
  mapSizeToTitleTypography,
} from './EmptyBlock.config';
import css from './EmptyBlock.module.css';

export const EmptyBlock: FC<EmptyBlockProps> = (props) => {
  const {
    className,
    children,
    icon,
    iconProvider,
    title,
    description,
    size = 's',
    view = 'light',
  } = props;

  const renderIcon = () => {
    const iconCls = cx(css.EmptyBlock__icon, css[`EmptyBlock__icon_size_${size}`]);

    if (iconProvider) return iconProvider(iconCls);

    return icon && <Icon className={iconCls} svg={icon} svgSize={mapSizeToSvgSize[size]} />;
  };

  const color = mapViewToTextColor[view];

  return (
    <div className={cx(className, css.EmptyBlock)}>
      {renderIcon()}
      {title && (
        <Text
          as="div"
          typography={mapSizeToTitleTypography[size]}
          weight="medium"
          color={color}
          className={cx(css.EmptyBlock__title, css[`EmptyBlock__title_size_${size}`])}
        >
          {title}
        </Text>
      )}
      {description && (
        <Text as="div" typography="body-long-m" color={color}>
          {description}
        </Text>
      )}

      {children && <div className={css.EmptyBlock__footer}>{children}</div>}
    </div>
  );
};
