import React, { FC } from 'react';
import cx from 'classnames';
import { EmptyBlock } from 'components/EmptyBlock';
import { ErrorBlockProps } from './ErrorBlock.types';
import css from './ErrorBlock.module.css';

export const ErrorBlock: FC<ErrorBlockProps> = (props) => {
  const { error, message, children } = props;

  let content = children;
  if (error) {
    content = error.message;
  } else if (message) {
    content = message;
  }

  return (
    <EmptyBlock className={(cx(props.className), css.ErrorBlock)}>Error: {content}</EmptyBlock>
  );
};
