import React from 'react';
import { ErrorBlock } from 'components/ErrorBlock';
import { convertAnyToError } from 'services/Logger';
import { ErrorBoundaryState, ErrorBoundaryProps } from './ErrorBoundary.types';

export class ErrorBoundary extends React.Component<ErrorBoundaryProps, ErrorBoundaryState> {
  static getDerivedStateFromError(error) {
    return { error: convertAnyToError(error) };
  }

  constructor(props) {
    super(props);

    this.state = {};
  }

  componentDidCatch(error) {
    this.props.onError?.(convertAnyToError(error));
  }

  render() {
    const { error } = this.state;
    const { renderFallback, children } = this.props;

    if (error) {
      return renderFallback?.(error) ?? <ErrorBlock error={error} />;
    }

    return <>{children}</>;
  }
}
