import React from 'react';
import { ErrorBoundary } from 'components/ErrorBoundary';
import { logger } from 'services/Logger';
import { ErrorBoundaryModuleProps } from './ErrorBoundaryModule.types';
import css from './ErrorBoundaryModule.module.css';

export const ErrorBoundaryModule: React.FC<ErrorBoundaryModuleProps> = (props) => {
  const fallback = () => {
    return (
      <div className={css.ErrorBoundaryModule}>
        <div>ОШИБКА ЗАГРУЗКИ МОДУЛЯ</div>
        <div>Попробуйте обновить страницу</div>
      </div>
    );
  };

  const handleError = (error: Error) => {
    logger.reportError(error, 'FATAL');
  };

  return <ErrorBoundary {...props} renderFallback={fallback} onError={handleError} />;
};
