import React from 'react';
import css from './Error.modules.scss';

const MESSAGES = {
  backend: 'Backend error 500',
  frontend: 'Frontend error',
};

interface Props {
  type: string;
  error?: Error;
}

const errorsToBeShown = ['ChunkLoadError'];

interface ErrorToBeShown extends Error {
  userMessage: string;
  [key: string]: unknown;
}

const isErrorWithPresentation = (error: Error): error is ErrorToBeShown => {
  return errorsToBeShown.includes(error.name);
};

const Error = ({ type, error }: Props) => (
  <div className={css.Error__wrap}>
    <div className={css.Error}>
      <div className={css.Error__logo} />
      <div className={css.Error__text}>
        <div className={css.Error__title}>
          Space упал{' '}
          <span role="img" aria-label="scream">
            &#x1F631;
          </span>
        </div>
        <div className={css.Error__message}>
          <div className={css.Error__type}>{MESSAGES[type]}</div>
          <div className={css.Error__text}>
            {error && isErrorWithPresentation(error) && error?.userMessage}
          </div>
        </div>
      </div>
    </div>
  </div>
);

Error.defaultProps = {
  type: 'backend',
};

export default Error;
