import React from 'react';
import css from './BookingRange.module.css';
import { BookingRangeProps } from './BookingRange.types';
import { getRelativePercentageStart, getRelativePercentageEnd } from '../EventWidget.utils';

export const BookingRange: React.FC<BookingRangeProps> = ({ date, bookingRange, viewRange }) => {
  if (!bookingRange) {
    return null;
  }

  return (
    <div
      data-testid="booking-range"
      style={{
        left: getRelativePercentageStart(bookingRange.start, date, viewRange),
        right: getRelativePercentageEnd(bookingRange.end, date, viewRange),
      }}
      className={css.b}
    />
  );
};
