import React, { useEffect } from 'react';
import { EventWidget } from './EventWidget';
import { Participant, DateRange, NumberRange } from './EventWidget.types';

const EventWidgetStories = ({
  date,
  viewRangeStart,
  viewRangeEnd,
  bookingRangeStart,
  bookingRangeEnd,
  participantName,
  participantEventStart,
  participantEventEnd,
}) => {
  const [chosenDate, setChosenDate] = React.useState(new Date());

  const viewRange: NumberRange = { start: viewRangeStart, end: viewRangeEnd };

  const bookingRange: DateRange = {
    start: new Date(bookingRangeStart),
    end: new Date(bookingRangeEnd),
  };

  const participant: Participant = {
    name: participantName,
    events: [
      {
        id: 1,
        range: {
          start: new Date(participantEventStart),
          end: new Date(participantEventEnd),
        },
      },
    ],
  };

  useEffect(() => {
    setChosenDate(new Date(date));
  }, [date]);

  return (
    <div style={{ padding: 150 }}>
      <EventWidget
        date={chosenDate}
        participants={[participant, participant]}
        onNavigate={setChosenDate}
        viewRange={viewRange}
        bookingRange={bookingRange}
      />
    </div>
  );
};

export default {
  title: 'EventWidget/Controls',
  component: EventWidgetStories,
};
export const Default = (args) => <EventWidgetStories {...args} />;

Default.args = {
  date: new Date(),
  viewRangeStart: 0,
  viewRangeEnd: 24,
  bookingRangeStart: '2021-06-03T09:30:00',
  bookingRangeEnd: '2021-06-05T11:30:00',
  participantName: 'Андрей Ульянов',
  participantEventStart: '2021-06-03T08:10:00',
  participantEventEnd: '2021-06-03T12:30:00',
};

Default.argTypes = {
  date: {
    name: 'Date',
    control: {
      type: 'date',
    },
  },
  viewRangeStart: {
    name: 'Start',
    control: {
      type: 'range',
      min: 0,
      max: 23,
    },
    table: {
      category: 'View Range',
    },
  },
  viewRangeEnd: {
    name: 'End',
    control: {
      type: 'range',
      min: 1,
      max: 24,
    },
    table: {
      category: 'View Range',
    },
  },
  bookingRangeStart: {
    name: 'Start',
    control: {
      type: 'date',
    },
    table: {
      category: 'Booking Range',
    },
  },
  bookingRangeEnd: {
    name: 'End',
    control: {
      type: 'date',
    },
    table: {
      category: 'Booking Range',
    },
  },
  participantName: {
    name: 'Name',
    control: {
      type: 'text',
    },
    table: {
      category: 'Participant',
    },
  },
  participantEventStart: {
    name: 'Start',
    control: {
      type: 'date',
    },
    table: {
      category: 'Participant',
      subcategory: 'Event',
    },
  },
  participantEventEnd: {
    name: 'End',
    control: {
      type: 'date',
    },
    table: {
      category: 'Participant',
      subcategory: 'Event',
    },
  },
};
