import React from 'react';
import cx from 'classnames';
import css from './EventWidget.module.css';
import { Props } from './EventWidget.types';
import { HourHeader } from './HourHeader';
import { Hour } from './Hour';
import { TimeMarker } from './TimeMarker';
import { Timeline } from './Timeline';
import { BookingRange } from './BookingRange';
import { DayNavigationHeader } from './NavigationHeader';

import { DEFAULT_VIEW_RANGE } from './EventWidget.config';
import { numberRangeToArray } from './EventWidget.utils';

export const EventWidget: React.FC<Props> = (props) => {
  const {
    className,
    date,
    participants,
    bookingRange,
    viewRange = DEFAULT_VIEW_RANGE,
    onNavigate,
  } = props;

  return (
    <div className={cx(css.b, className)}>
      <DayNavigationHeader date={date} onNavigate={onNavigate} />
      <div className={css.b__content}>
        <div data-testid="hour-headers" className={css.b__contentRow}>
          {numberRangeToArray(viewRange).map((value) => (
            <HourHeader key={value} title={value} />
          ))}
        </div>
        <div className={css.b__contentRow}>
          <div data-testid="hours" className={css.b__hours}>
            {numberRangeToArray(viewRange).map((value) => (
              <Hour key={value} />
            ))}
          </div>
          <div data-testid="timelines" className={css.b__participants}>
            {participants?.map((participant, index) => (
              <Timeline key={index} {...participant} date={date} viewRange={viewRange} />
            ))}
          </div>
        </div>
        <BookingRange date={date} bookingRange={bookingRange} viewRange={viewRange} />
        {new Date().toDateString() === date?.toDateString() && (
          <TimeMarker date={new Date()} viewRange={viewRange} />
        )}
      </div>
    </div>
  );
};
