export interface Range<T> {
  start: T;
  end: T;
}

export type NumberRange = Range<number>;
export type DateRange = Range<Date>;

export interface Event {
  id: number;
  range: DateRange;
}

export interface Participant {
  name: string;
  events: Event[];
}

export interface Props {
  className?: string;

  date?: Date;
  onNavigate?: (date: Date) => void;

  participants?: Participant[];
  bookingRange?: DateRange;
  viewRange?: NumberRange;
}

export interface AvailabilityPeriods {
  subjects: Subject[];
}

export interface Subject {
  name: string;
  activities: Activity[];
}

export interface Activity {
  fromDateTime: string;
  toDateTime: string;
}
