import { ONE_HOUR, MAX_PERCENTAGE } from './EventWidget.config';
import { NumberRange } from './EventWidget.types';

export const getRelativePercentageStart = (
  date?: Date,
  relativeDate?: Date,
  viewRange?: NumberRange,
) => {
  if (!date || !relativeDate || !viewRange) {
    return '0%';
  }

  let result = 0;

  if (date.toDateString() === relativeDate.toDateString()) {
    let currentMinutes = date.getHours() * ONE_HOUR + date.getMinutes();
    let startMinutes = viewRange.start * ONE_HOUR;
    let endMinutes = viewRange.end * ONE_HOUR;

    currentMinutes = currentMinutes > startMinutes ? currentMinutes : startMinutes;
    result =
      (Math.abs(currentMinutes - startMinutes) / Math.abs(startMinutes - endMinutes)) *
      MAX_PERCENTAGE;
  } else if (date > relativeDate) {
    result = MAX_PERCENTAGE;
  }

  return result + '%';
};

export const getRelativePercentageEnd = (
  date?: Date,
  relativeDate?: Date,
  viewRange?: NumberRange,
) => {
  if (!date || !relativeDate || !viewRange) {
    return MAX_PERCENTAGE + '%';
  }

  let result = MAX_PERCENTAGE;

  if (date.toDateString() === relativeDate.toDateString()) {
    let currentMinutes = date.getHours() * ONE_HOUR + date.getMinutes();
    let startMinutes = viewRange.start * ONE_HOUR;
    let endMinutes = viewRange.end * ONE_HOUR;

    currentMinutes = currentMinutes < endMinutes ? currentMinutes : endMinutes;
    result =
      (Math.abs(endMinutes - currentMinutes) / Math.abs(startMinutes - endMinutes)) *
      MAX_PERCENTAGE;
  } else if (date > relativeDate) {
    result = 0;
  }

  return result + '%';
};

export const numberRangeToArray = (numberRange: NumberRange): number[] => {
  let result: number[] = [];

  for (let i = numberRange.start; i < numberRange.end; i++) {
    result.push(i);
  }

  return result;
};
