import React from 'react';
import { FormattedDate } from 'react-intl';
import Icon from '@crm/components/dist/lego2/Icon';
import Button from '@crm/components/dist/lego2/Button';
import addDays from 'date-fns/addDays';
import css from './DayNavigationHeader.module.css';
import { NavigationHeaderProps } from '../NavigationHeader.types';

const iconProvider = (direction) => (className) => (
  <Icon className={className} type="arrow" direction={direction} />
);

export const DayNavigationHeader: React.FC<NavigationHeaderProps> = (props) => {
  const { date, onNavigate } = props;

  const handleNextClick = () => {
    if (date && onNavigate) {
      onNavigate(addDays(date, 1));
    }
  };

  const handlePreviousClick = () => {
    if (date && onNavigate) {
      onNavigate(addDays(date, -1));
    }
  };

  return (
    <div className={css.b}>
      <Button
        view="clear"
        data-testid="button-previous-date"
        className={css.b__button}
        onClick={handlePreviousClick}
        icon={iconProvider('left')}
      />
      <div data-testid="date-title" className={css.b__title}>
        {date && <FormattedDate value={date} weekday="long" month="long" day="numeric" />}
      </div>
      <Button
        view="clear"
        data-testid="button-next-date"
        className={css.b__button}
        onClick={handleNextClick}
        icon={iconProvider('right')}
      />
    </div>
  );
};
