import React from 'react';
import css from './TimeMarker.module.css';
import { TimeMarkerProps } from './TimeMarker.types';
import { getRelativePercentageStart } from '../EventWidget.utils';

export const TimeMarker: React.FC<TimeMarkerProps> = ({ date, viewRange }) => {
  return (
    <div
      data-testid="timemarker"
      style={{
        left: getRelativePercentageStart(date, date, viewRange),
      }}
      className={css.b}
    />
  );
};
