import React from 'react';
import css from './Timeline.module.css';
import { TimelineProps } from './Timeline.types';
import { TimelineCell } from '../TimelineCell';

export const Timeline: React.FC<TimelineProps> = (props) => {
  const { name, date, viewRange, events } = props;

  return (
    <div className={css.b}>
      <div className={css.b__header}>{name}</div>
      {events?.map((event) => (
        <TimelineCell key={event.id} date={date} range={event.range} viewRange={viewRange} />
      ))}
    </div>
  );
};
