import React from 'react';
import css from './TimelineCell.module.css';
import { TimelineCellProps } from './TimelineCell.types';
import { getRelativePercentageStart, getRelativePercentageEnd } from '../EventWidget.utils';

export const TimelineCell: React.FC<TimelineCellProps> = ({ date, range, viewRange }) => {
  return (
    <div
      style={{
        left: getRelativePercentageStart(range?.start, date, viewRange),
        right: getRelativePercentageEnd(range?.end, date, viewRange),
      }}
      className={css.b}
    />
  );
};
